/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.ConfigurationException;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.netflix.governator.annotations.WarmUp;
import com.netflix.governator.lifecycle.LifecycleListener;
import com.netflix.governator.lifecycle.LifecycleManager;
import com.netflix.governator.lifecycle.LifecycleMethods;
import com.netflix.governator.lifecycle.warmup.DAGManager;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;

class InternalLifecycleModule
extends AbstractModule {
    private final CopyOnWriteArraySet<Dependency<?>> seen = new CopyOnWriteArraySet();
    private final LoadingCache<Class<?>, LifecycleMethods> lifecycleMethods = CacheBuilder.newBuilder().softValues().build(new CacheLoader<Class<?>, LifecycleMethods>(){

        public LifecycleMethods load(Class<?> key) throws Exception {
            return new LifecycleMethods(key);
        }
    });
    private final AtomicReference<LifecycleManager> lifecycleManager;

    InternalLifecycleModule(AtomicReference<LifecycleManager> lifecycleManager) {
        this.lifecycleManager = lifecycleManager;
    }

    public void configure() {
        this.bindListener(Matchers.any(), new TypeListener(){

            public <T> void hear(final TypeLiteral<T> type, TypeEncounter<T> encounter) {
                encounter.register(new InjectionListener<T>(){

                    public void afterInjection(T obj) {
                        InternalLifecycleModule.this.processInjectedObject(obj, type);
                    }
                });
            }
        });
    }

    private <T> void processInjectedObject(T obj, TypeLiteral<T> type) {
        LifecycleManager manager = this.lifecycleManager.get();
        if (manager != null) {
            for (LifecycleListener listener : manager.getListeners()) {
                listener.objectInjected(type, obj);
            }
            Class<?> clazz = obj.getClass();
            LifecycleMethods methods = this.getLifecycleMethods(clazz);
            if (this.warmUpIsInDag(clazz, type)) {
                this.addDependencies(manager, obj, type, methods);
            }
            if (methods.hasLifecycleAnnotations()) {
                try {
                    manager.add(obj, methods);
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
        }
    }

    private void addDependencies(LifecycleManager manager, Object obj, TypeLiteral<?> type, LifecycleMethods methods) {
        DAGManager dagManager = manager.getDAGManager();
        dagManager.addObjectMapping(type, obj, methods);
        this.applyInjectionPoint(this.getConstructorInjectionPoint(type), dagManager, type);
        for (InjectionPoint injectionPoint : this.getMethodInjectionPoints(type)) {
            this.applyInjectionPoint(injectionPoint, dagManager, type);
        }
    }

    private boolean warmUpIsInDag(Class<?> clazz, TypeLiteral<?> type) {
        LifecycleMethods methods = this.getLifecycleMethods(clazz);
        if (methods.methodsFor(WarmUp.class).size() > 0) {
            return true;
        }
        if (this.warmUpIsInDag(this.getConstructorInjectionPoint(type))) {
            return true;
        }
        for (InjectionPoint injectionPoint : this.getMethodInjectionPoints(type)) {
            if (!this.warmUpIsInDag(injectionPoint)) continue;
            return true;
        }
        return false;
    }

    private boolean warmUpIsInDag(InjectionPoint injectionPoint) {
        if (injectionPoint == null) {
            return false;
        }
        List dependencies = injectionPoint.getDependencies();
        for (Dependency dependency : dependencies) {
            if (!this.seen.add(dependency) || !this.warmUpIsInDag(dependency.getKey().getTypeLiteral().getRawType(), dependency.getKey().getTypeLiteral())) continue;
            return true;
        }
        return false;
    }

    private Set<InjectionPoint> getMethodInjectionPoints(TypeLiteral<?> type) {
        try {
            return InjectionPoint.forInstanceMethodsAndFields(type);
        }
        catch (NullPointerException e) {
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        return Sets.newHashSet();
    }

    private InjectionPoint getConstructorInjectionPoint(TypeLiteral<?> type) {
        try {
            return InjectionPoint.forConstructorOf(type);
        }
        catch (ConfigurationException configurationException) {
            return null;
        }
    }

    private void applyInjectionPoint(InjectionPoint injectionPoint, DAGManager dagManager, TypeLiteral<?> type) {
        if (injectionPoint != null) {
            for (Dependency dependency : injectionPoint.getDependencies()) {
                dagManager.addDependency(type, dependency.getKey().getTypeLiteral());
            }
        }
    }

    private LifecycleMethods getLifecycleMethods(Class<?> clazz) {
        try {
            return (LifecycleMethods)this.lifecycleMethods.get(clazz);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

