/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.lifecycle.warmup;

import com.google.common.collect.Iterators;
import com.netflix.governator.lifecycle.warmup.WarmUpException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class WarmUpErrors
implements Iterable<Error> {
    private final Queue<Error> errors = new ConcurrentLinkedQueue<Error>();

    public Throwable addError(Throwable e, String context) {
        while (InvocationTargetException.class.isAssignableFrom(e.getClass())) {
            if (e.getCause() == null) continue;
            e = e.getCause();
        }
        this.errors.add(new Error(e, context));
        return e;
    }

    public void throwIfErrors() throws WarmUpException {
        if (this.errors.size() > 0) {
            throw new WarmUpException(this);
        }
    }

    @Override
    public Iterator<Error> iterator() {
        return Iterators.unmodifiableIterator(this.errors.iterator());
    }

    public static class Error {
        private final Throwable exception;
        private final String context;

        public Throwable getException() {
            return this.exception;
        }

        public String getContext() {
            return this.context;
        }

        private Error(Throwable exception, String context) {
            this.exception = exception;
            this.context = context;
        }
    }
}

