/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.netflix.governator.GovernatorFeature;
import com.netflix.governator.GovernatorFeatures;
import com.netflix.governator.LegacyScopesModule;
import com.netflix.governator.LifecycleInjector;
import com.netflix.governator.LifecycleManager;
import com.netflix.governator.LifecycleModule;
import com.netflix.governator.annotations.SuppressLifecycleUninitialized;
import com.netflix.governator.annotations.binding.Arguments;
import com.netflix.governator.annotations.binding.Profiles;
import com.netflix.governator.internal.DefaultPropertySource;
import com.netflix.governator.internal.GovernatorFeatureSet;
import com.netflix.governator.spi.InjectorCreator;
import com.netflix.governator.spi.PropertySource;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleInjectorCreator
implements InjectorCreator<LifecycleInjector> {
    private static final Logger LOG = LoggerFactory.getLogger(LifecycleInjectorCreator.class);
    private String[] args = new String[0];
    private LinkedHashSet<String> profiles = new LinkedHashSet();
    private IdentityHashMap<GovernatorFeature<?>, Object> features = new IdentityHashMap();

    public LifecycleInjectorCreator withArguments(String[] args) {
        this.args = args;
        return this;
    }

    public LifecycleInjectorCreator withProfiles(String ... profiles) {
        this.profiles = new LinkedHashSet<String>(Arrays.asList(profiles));
        return this;
    }

    public LifecycleInjectorCreator withProfiles(Set<String> profiles) {
        this.profiles = new LinkedHashSet<String>(profiles);
        return this;
    }

    public LifecycleInjectorCreator withFeatures(IdentityHashMap<GovernatorFeature<?>, Object> features) {
        this.features = features;
        return this;
    }

    @Override
    public LifecycleInjector createInjector(Stage stage, Module module) {
        final GovernatorFeatureSetImpl featureSet = new GovernatorFeatureSetImpl(this.features);
        final LifecycleManager manager = new LifecycleManager();
        try {
            this.onBeforeInjectorCreate();
            Injector injector = Guice.createInjector((Stage)stage, (Module[])new Module[]{module, new LifecycleModule(), new LegacyScopesModule(), new AbstractModule(){

                protected void configure() {
                    this.bind(GovernatorFeatureSet.class).toInstance((Object)featureSet);
                    this.bind(LifecycleManager.class).toInstance((Object)manager);
                    this.bind((TypeLiteral)new TypeLiteral<Set<String>>(){}).annotatedWith(Profiles.class).toInstance((Object)LifecycleInjectorCreator.this.profiles);
                    this.bind(String[].class).annotatedWith(Arguments.class).toInstance((Object)LifecycleInjectorCreator.this.args);
                    this.requestInjection(LifecycleInjectorCreator.this);
                }
            }});
            manager.notifyStarted();
            LifecycleInjector lifecycleInjector = LifecycleInjector.wrapInjector(injector, manager);
            this.onSuccessfulInjectorCreate();
            LifecycleInjector lifecycleInjector2 = lifecycleInjector;
            return lifecycleInjector2;
        }
        catch (Exception e) {
            LOG.error("Failed to create injector", (Throwable)e);
            this.onFailedInjectorCreate(e);
            try {
                manager.notifyStartFailed(e);
            }
            catch (Exception e2) {
                LOG.error("Failed to notify injector creation failure", (Throwable)e2);
            }
            if (!featureSet.get(GovernatorFeatures.SHUTDOWN_ON_ERROR).booleanValue()) {
                LifecycleInjector lifecycleInjector = LifecycleInjector.createFailedInjector(manager);
                return lifecycleInjector;
            }
            throw e;
        }
        finally {
            this.onCompletedInjectorCreate();
        }
    }

    protected void onBeforeInjectorCreate() {
    }

    protected void onSuccessfulInjectorCreate() {
    }

    protected void onFailedInjectorCreate(Throwable error) {
    }

    protected void onCompletedInjectorCreate() {
    }

    public String toString() {
        return "LifecycleInjectorCreator[]";
    }

    @Singleton
    @SuppressLifecycleUninitialized
    class GovernatorFeatureSetImpl
    implements GovernatorFeatureSet {
        private final IdentityHashMap<GovernatorFeature<?>, Object> featureOverrides;
        @Inject
        private PropertySource properties = new DefaultPropertySource();

        @Inject
        public GovernatorFeatureSetImpl(IdentityHashMap<GovernatorFeature<?>, Object> featureOverrides) {
            this.featureOverrides = featureOverrides;
        }

        @Override
        public <T> T get(GovernatorFeature<T> feature) {
            return (T)(this.featureOverrides.containsKey(feature) ? this.featureOverrides.get(feature) : this.properties.get(feature.getKey(), feature.getType(), feature.getDefaultValue()));
        }
    }
}

