/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.internal;

import com.netflix.governator.LifecycleAction;
import com.netflix.governator.internal.AbstractLifecycleFeature;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import javax.annotation.PreDestroy;

public final class PreDestroyLifecycleActions
extends AbstractLifecycleFeature {
    public static PreDestroyLifecycleActions INSTANCE = new PreDestroyLifecycleActions();

    private PreDestroyLifecycleActions() {
    }

    @Override
    protected List<LifecycleAction> getMethodActions(final Class<?> type, final Method method) {
        if (null != method.getAnnotation(PreDestroy.class)) {
            method.setAccessible(true);
            return Collections.singletonList(new LifecycleAction(){

                @Override
                public void call(Object obj) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                    method.invoke(obj, new Object[0]);
                }

                public String toString() {
                    return "PreDestroy[" + type.getName() + "#" + method.getName() + "]";
                }
            });
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "PreDestroy";
    }
}

