/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.common.exception;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;

public final class RedisConstants {
    public static final String GOODS_POOL_KEY = "MINIPROGRAM:GOODSPOOL:LIST";
    public static final String TAG_CONFIG_KEY = "MINIPROGRAM:TAG:CONFIG";
    public static final String BANNER_CONFIG_KEY = "MINIPROGRAM:BANNER:LIST";
    public static final String CHANNEL_KEY = "MINIPROGRAM:CHANNEL:LIST";
    public static final String REBATE_CONFIG_KEY = "MINIPROGRAM:REBATE:LIST";
    public static final String POP_LIST_KEY = "MINIPROGRAM:POP:LIST";
    public static final String PDD_GOODS_LIST_CACHE_KEY = "MINIPROGRAM:PDD_GOODS:LIST:%s";
    public static final String PDD_GOODS_DETAIL_CACHE_KEY = "MINIPROGRAM:PDD_GOODS:DETAIL:%s";
    public static final String PDD_THEME_GOODS_CACHE_KEY = "MINIPROGRAM:PDD:THEME:GOODS:%s";
    public static final String FREE_TIMES = "MINIPROGRAM:FREE:TIMES";
    public static final String SHARE_FREE_TIMES = "MINIPROGRAM:SHARE:FREE:TIMES";
    public static final String INIT_FREE_TIMES = "MINIPROGRAM:INIT:FREE:TIMES";
    public static final String FREE_MAX_AMOUNT = "MINIPROGRAM:FREE:MAX:AMOUNT";
    public static final String HANDING_FREE_ORDER = "MINIPROGRAM:HANDING:FREE:ORDER:%s";

    private RedisConstants() {
    }

    public static final class Wechat {
        public static final Integer VALID_TIME = 7190;

        public static KeyGenerator getAccessToken() {
            return () -> KeyBuilder.build((Object[])new Object[]{"MINIPROGRAM", "WECHAT", "ACCESSTOKEN"});
        }
    }

    public static final class Favorite {
        public static KeyGenerator getMyFavorite(String openid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"MINIPROGRAM", "MYFAVORITE", openid});
        }
    }

    public static final class Share {
        public static KeyGenerator getShareInfo() {
            return () -> KeyBuilder.build((Object[])new Object[]{"MINIPROGRAM", "SHARE"});
        }
    }

    public static final class Wallet {
        public static KeyGenerator getWalletInfo() {
            return () -> KeyBuilder.build((Object[])new Object[]{"MINIPROGRAM", "WALLET", "INFO"});
        }

        public static KeyGenerator getFreezeOrUsed() {
            return () -> KeyBuilder.build((Object[])new Object[]{"MINIPROGRAM", "WALLET", "FREEZEORUSED"});
        }

        public static KeyGenerator getWalletToken(String openid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"MINIPROGRAM", "WALLET", "TOKEN", openid});
        }

        public static KeyGenerator getRetrySwitch() {
            return () -> KeyBuilder.build((Object[])new Object[]{"MINIPROGRAM", "WALLET", "RETRY", "SWITCH"});
        }

        public static KeyGenerator getWithdrawLongck(String openid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"MINIPROGRAM", "WALLET", "LOCK", openid});
        }
    }

    public static final class Friend {
        public static KeyGenerator getDirectFriend(String openid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"MINIPROGRAM", "FRIEND", "DIRECT", openid});
        }

        public static KeyGenerator getIndirectFriend(String openid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"MINIPROGRAM", "FRIEND", "INDIRECT", openid});
        }
    }

    public static final class Order {
        public static KeyGenerator getOrderLastUpdatetimeAndStatus() {
            return () -> KeyBuilder.build((Object[])new Object[]{"MINIPROGRAM", "ORDER", "UPDATETIMEANDSTATUS"});
        }

        public static KeyGenerator getDefaultRebateConfig() {
            return () -> KeyBuilder.build((Object[])new Object[]{"MINIPROGRAM", "DEFAULT", "REBATE"});
        }

        public static KeyGenerator getOrderIncrementSynTime() {
            return () -> KeyBuilder.build((Object[])new Object[]{"MINIPROGRAM", "ORDER", "INCREAMENSYNTIME"});
        }

        public static KeyGenerator getOrderSyncLock(String customParameters) {
            return () -> KeyBuilder.build((Object[])new Object[]{"MINIPROGRAM", "ORDER", "LOCK", customParameters});
        }
    }

    public static class User {
        public static final Integer SESSION_TIME = 3600;

        public static KeyGenerator getUserInfo() {
            return () -> KeyBuilder.build((Object[])new Object[]{"MINIPROGRAM", "USER", "CACHE", "INFO"});
        }

        public static KeyGenerator getSessionId(String openid, String sessionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"MINIPROGRAM", "USER", "SESSIONID", openid, sessionId});
        }
    }
}

