/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.common.exception;

import com.bxm.shop.common.exception.ResponseCodeType;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;

public class ShopsException
extends RuntimeException
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ResponseCodeType codeType;
    private Throwable cause;
    private String errorCode;

    public ShopsException(ResponseCodeType codeType, String ... msg) {
        this(codeType.getErrorCode(), msg.length <= 0 ? codeType.getErrorMsg() : String.format(codeType.getErrorMsg(), msg));
        this.codeType = codeType;
    }

    public ResponseCodeType getCodeType() {
        return this.codeType;
    }

    public ShopsException(String errorMsg) {
        this("", errorMsg);
    }

    public ShopsException(Throwable cause) {
        this(cause, ResponseCodeType.SYSTEM_ERROR.getErrorCode(), ResponseCodeType.SYSTEM_ERROR.getErrorMsg());
    }

    public ShopsException(String errorCode, String errorMsg) {
        this((Throwable)null, errorCode, errorMsg);
    }

    public ShopsException(Throwable cause, String errorCode, String errorMsg) {
        super(errorMsg);
        this.cause = cause;
        this.errorCode = errorCode;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream ps) {
        if (null == this.getCause()) {
            super.printStackTrace(ps);
        } else {
            ps.println(this);
            this.getCause().printStackTrace(ps);
        }
    }

    @Override
    public void printStackTrace(PrintWriter pw) {
        if (null == this.getCause()) {
            super.printStackTrace(pw);
        } else {
            pw.println(this);
            this.getCause().printStackTrace(pw);
        }
    }

    @Override
    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    @Override
    public String getMessage() {
        if (this.getCause() == null) {
            return super.getMessage();
        }
        return super.getMessage() + this.getCause().getMessage();
    }

    public String getErrorCode() {
        return this.errorCode;
    }
}

