/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.common.utils;

import com.sun.jndi.toolkit.url.UrlUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CustomParameterUtils {
    private static final Logger log = LoggerFactory.getLogger(CustomParameterUtils.class);
    public static final String SPLIT = "\\|";

    private CustomParameterUtils() {
    }

    public static String generateCustomParameter(Long orderId, Long shareId, String openid) {
        if (null == orderId) {
            orderId = 0L;
        }
        if (null == shareId) {
            shareId = 0L;
        }
        return StringUtils.join((Object[])new String[]{orderId + "", shareId + "", openid}, (String)"|");
    }

    public static Long getOrderId(String customParameter) {
        try {
            customParameter = UrlUtil.decode(customParameter, "UTF-8");
        }
        catch (Exception e) {
            log.error("decode\u81ea\u5b9a\u4e49\u53c2\u6570\u5931\u8d25", (Throwable)e);
        }
        String[] split = customParameter.split(SPLIT);
        if (null != split && split.length > 0) {
            return Long.valueOf(split[0]);
        }
        return 0L;
    }

    public static Long getShareId(String customParameter) {
        String[] split = customParameter.split(SPLIT);
        if (null != split && split.length > 1) {
            return Long.valueOf(split[1]);
        }
        return 0L;
    }

    public static String getOpenid(String customParameter) {
        String[] split = customParameter.split(SPLIT);
        if (null != split && split.length > 2) {
            return split[2];
        }
        return null;
    }
}

