/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.common.utils;

import com.bxm.shop.common.utils.MD5Util;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamEncodeUtils {
    private static final Logger log = LoggerFactory.getLogger(ParamEncodeUtils.class);
    public static final Pattern PATTERN = Pattern.compile("(\\\\u(\\p{XDigit}{4}))");

    public static String getMd5Signature(Map<String, String> param, String clientSecret) {
        try {
            Map<String, String> sortMap = ParamEncodeUtils.sortMap(param);
            StringBuilder sb = new StringBuilder();
            sb.append(clientSecret);
            for (Map.Entry<String, String> entry : sortMap.entrySet()) {
                sb.append(entry.getKey().toString());
                sb.append(entry.getValue().toString());
            }
            sb.append(clientSecret);
            return MD5Util.gen(sb.toString());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    private static Map<String, String> sortMap(Map<String, String> param) {
        if (null == param || param.size() == 0) {
            return new TreeMap<String, String>();
        }
        TreeMap<String, String> rs = new TreeMap<String, String>(param);
        return rs;
    }

    public static String unicodeToString(String str) {
        Matcher matcher = PATTERN.matcher(str);
        while (matcher.find()) {
            char ch = (char)Integer.parseInt(matcher.group(2), 16);
            str = str.replace(matcher.group(1), ch + "");
        }
        return str;
    }

    public static String list2String(List<Object> list) {
        StringBuilder sb = new StringBuilder("[");
        if (CollectionUtils.isNotEmpty(list)) {
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                if (!(list.get(i) instanceof String)) continue;
                sb.append("\"" + list.get(i) + "\"");
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

