#!/bin/bash

if [ ! -f ~/run/shops-api.pid ]; then
  echo "Server [shops-api] doest not started!"
  exit
fi

pid=`cat ~/run/shops-api.pid`
if [ ! -n "${pid}" ]; then
  echo "illegal content in shops-api.pid!"
  exit
fi

process=`ps -aux|awk '{print $2}' | grep ${pid}`
if [ -n "${process}" ]; then
  echo "Server [shops-api] will be stop."
  kill ${pid}

  times=0
  while true
  do
    process=`ps -aux|awk '{print $2}' | grep ${pid}`
    if [ -n "${process}" ] && [ ${times} -lt 10 ]; then
      let times++
      sleep 1
    else
      break
    fi
  done

  process=`ps -aux|awk '{print $2}' | grep ${pid}`
  if [ -n "${process}" ]; then
    echo "Server [shops-api] cannot stop, Please check pid file 'shops-api.pid' and stop it by manually!"
    exit
  fi
else
  echo "Server [shops-api] has been stoped!"
fi

rm -f ~/run/shops-api.pid