package com.bxm.shop.integration;

import com.bxm.shop.facade.WechatService;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Component
public class WechatServiceIntegration {

    @Autowired
    private WechatService wechatService;

    /**
     * 获取accessToken
     * @return
     */
    public String getAccessToken(){
        ResultModel rs = wechatService.getAccessToken();
        if(null != rs && rs.isSuccessed()&& null != rs.getReturnValue()){
            return rs.getReturnValue().toString();
        }
        return null;
    }

    /**
     * 刷新accessToken
     * @return
     */
    public String refreshAccessToken(){
        ResultModel rs = wechatService.refreshAccessToken();
        if(null != rs && rs.isSuccessed()&& null != rs.getReturnValue()){
            return rs.getReturnValue().toString();
        }
        return null;
    }

}
