package com.bxm.shop.integration.pdd.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.shop.common.constants.PingduoduoConstant;
import com.bxm.shop.common.utils.JSONStringUnderscoreToCamel;
import com.bxm.shop.common.utils.OkHttpUtils;
import com.bxm.shop.common.utils.ParamEncodeUtils;
import com.bxm.shop.facade.model.order.OrderVo;
import com.bxm.shop.integration.config.PddConstants;
import com.bxm.shop.integration.config.PingduoduoConfig;
import com.bxm.shop.integration.pdd.CommonGoodsPromotionUrlIntegration;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Map;

import static com.bxm.shop.common.utils.ParamEncodeUtils.unicodeToString;

@Component
@Slf4j
public class CommonGoodsPromotionUrlIntegrationImpl implements CommonGoodsPromotionUrlIntegration {

    @Autowired
    private PingduoduoConfig pingduoduoConfig;

    @Override
    public OrderVo generate(String goodsId, String customParam) {
        Map<String,String> param = pingduoduoConfig.getCommonParam();
        param.put(PingduoduoConstant.Param.TYPE, PddConstants.COMMON_GOODS_PROMOTION);
        param.put(PingduoduoConstant.Param.P_ID,pingduoduoConfig.getDefaultPid());
        param.put(PingduoduoConstant.Param.GOODS_ID_LISTS,"["+goodsId+"]");
        param.put(PingduoduoConstant.Param.CUSTOM_PARAMETERS,customParam);
        param.put(PingduoduoConstant.Param.GENERATE_WE_APP, PingduoduoConstant.Param.TRUE);

        String sign = ParamEncodeUtils.getMd5Signature(param, pingduoduoConfig.getClientSecret());
        param.put(PingduoduoConstant.Param.SIGN,sign);
        String response = null;
        try {
            response = OkHttpUtils.post(PddConstants.URL, param);
            response = unicodeToString(response);
            if(null != response) {
                JSONObject obj = JSON.parseObject(response);
                if(null != obj && obj.getJSONObject("goods_promotion_url_generate_response") != null){
                    JSONArray jsonArray = obj.getJSONObject("goods_promotion_url_generate_response").
                            getJSONArray("goods_promotion_url_list");
                    if(null != jsonArray&& jsonArray.size()>0){
                        JSONObject urlObj = (JSONObject) jsonArray.get(0);
                        String weAppInfo = JSONStringUnderscoreToCamel.transform(urlObj.getString("we_app_info"));
                        return JSON.parseObject(weAppInfo,OrderVo.class);
                    }
                }
            }
        } catch (IOException e) {
            log.error("CommonDoodsPromotionUrlIntegrationImpl.generate  Error",e);
        }
        return null;
    }


}
