/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.integration;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shop.common.exception.ResponseCodeType;
import com.bxm.shop.common.exception.ShopsException;
import com.bxm.shop.integration.RebateConfig;
import com.bxm.shopmanager.facade.model.GoodsPoolDTO;
import com.bxm.shopmanager.facade.service.ConfigService;
import com.bxm.warcar.utils.response.ResultModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ShopManagerIntegration {
    private static final Logger log = LoggerFactory.getLogger(ShopManagerIntegration.class);
    @Resource
    private ConfigService configService;
    @Resource
    private Mapper mapper;

    public Map<Long, GoodsPoolDTO> getGoodsPoolsByIds(List<Long> ids) {
        try {
            if (ids == null) {
                throw new ShopsException(ResponseCodeType.PARAM_ILLEGAL, new String[]{"\u5546\u54c1\u6c60id\u4e0d\u80fd\u4e3a\u7a7a"});
            }
            ResultModel response = this.configService.getGoodsPoolByIds((List)Lists.newArrayList(ids));
            if (response != null && response.isSuccessed()) {
                return (Map)response.getReturnValue();
            }
            log.error("\u8bf7\u6c42\u7ba1\u7406\u540e\u53f0\u7cfb\u7edf\u83b7\u53d6\u5546\u54c1\u6c60\u54cd\u5e94\u5f02\u5e38,\u8bf7\u6c42\u53c2\u6570{},\u54cd\u5e94\u53c2\u6570:{}", (Object)JSONObject.toJSONString(ids), (Object)JSONObject.toJSONString((Object)response));
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u540e\u53f0\u7ba1\u7406\u7cfb\u7edf\u83b7\u53d6\u5546\u54c1\u6c60\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
        }
        return Maps.newHashMap();
    }

    public GoodsPoolDTO getGoodsPoolById(Long id) {
        return this.getGoodsPoolsByIds(Lists.newArrayList((Object[])new Long[]{id})).get(id);
    }

    public Map<String, RebateConfig> getRebateByIds(List<String> ids) {
        HashMap result = Maps.newHashMap();
        try {
            if (ids == null || ids.isEmpty()) {
                throw new ShopsException(ResponseCodeType.PARAM_ILLEGAL, new String[]{"\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a"});
            }
            ResultModel response = this.configService.getRebateByIds(ids);
            if (response != null && response.isSuccessed()) {
                Map returnValue = (Map)response.getReturnValue();
                for (String key : returnValue.keySet()) {
                    result.put(key, this.mapper.map(returnValue.get(key), RebateConfig.class));
                }
                return result;
            }
            log.error("\u8bf7\u6c42\u540e\u53f0\u7ba1\u7406\u7cfb\u7edf\u83b7\u53d6\u8fd4\u4f63\u8fd4\u5229\u914d\u7f6e\u54cd\u5e94\u5f02\u5e38,\u8bf7\u6c42\u53c2\u6570{},\u54cd\u5e94\u53c2\u6570:{}", (Object)JSONObject.toJSONString(ids), (Object)JSONObject.toJSONString((Object)response));
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u540e\u53f0\u7ba1\u7406\u7cfb\u7edf\u83b7\u53d6\u8fd4\u4f63\u8fd4\u5229\u914d\u7f6e\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
        }
        return result;
    }

    public RebateConfig getRebateById(String id) {
        Map<String, RebateConfig> result = this.getRebateByIds(Lists.newArrayList((Object[])new String[]{id}));
        return result.get(id);
    }

    public static enum GoodsPoolType {
        FREE(1L),
        TOP(2L);

        private Long id;

        private GoodsPoolType(Long id) {
            this.id = id;
        }

        public Long getId() {
            return this.id;
        }
    }
}

