/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.integration.pdd.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.shop.common.utils.JSONStringUnderscoreToCamel;
import com.bxm.shop.common.utils.OkHttpUtils;
import com.bxm.shop.common.utils.ParamEncodeUtils;
import com.bxm.shop.facade.model.order.OrderDto;
import com.bxm.shop.facade.model.order.PddOrderList;
import com.bxm.shop.integration.config.PingduoduoConfig;
import com.bxm.shop.integration.pdd.OrderIncrementGetIntegration;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrderIncrementGetIntegrationImpl
implements OrderIncrementGetIntegration {
    private static final Logger log = LoggerFactory.getLogger(OrderIncrementGetIntegrationImpl.class);
    @Autowired
    private PingduoduoConfig pingduoduoConfig;

    @Override
    public PddOrderList getIncrementOrder(OrderDto dto, Boolean retrunCount) {
        if (null == retrunCount) {
            retrunCount = true;
        }
        Map<String, String> param = this.pingduoduoConfig.getCommonParam();
        param.put("type", "pdd.ddk.order.list.increment.get");
        param.put("start_update_time", dto.getStartUpdateTime() + "");
        param.put("end_update_time", dto.getEndUpdateTime() + "");
        param.put("page", dto.getPageNum() + "");
        param.put("page_size", dto.getPageSize() + "");
        param.put("return_count", retrunCount.toString());
        String sign = ParamEncodeUtils.getMd5Signature(param, (String)this.pingduoduoConfig.getClientSecret());
        param.put("sign", sign);
        String response = null;
        try {
            JSONObject obj;
            response = OkHttpUtils.post((String)"https://gw-api.pinduoduo.com/api/router", param);
            response = ParamEncodeUtils.unicodeToString((String)response);
            if (null != response && null != (obj = JSON.parseObject((String)response)) && obj.getString("order_list_get_response") != null) {
                String orderInfo = JSONStringUnderscoreToCamel.transform((String)obj.getString("order_list_get_response"));
                return (PddOrderList)JSON.parseObject((String)orderInfo, PddOrderList.class);
            }
        }
        catch (IOException e) {
            log.error("CommonDoodsPromotionUrlIntegrationImpl.generate  Error", (Throwable)e);
        }
        return null;
    }
}

