package com.bxm.shop.config;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * 业务规则配置
 * @author bcc
 */
@Configuration
@ConfigurationProperties(prefix = "biz.config")
@Getter
@Setter
@ToString
public class BizConfig {

    /**
     * 最小提现金额阀值(分)
     */
    private Long amountLeastThreshold;

    /**
     * 提现说明：多多客提现到账
     */
    private String payDesc;
}
