package com.bxm.shop.config;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * 微信配置
 * @author bcc
 */
@Configuration
@ConfigurationProperties(prefix = "wechat.config")
@Getter
@Setter
@ToString
public class WechatConfig {

    private String jscode2sessionUrl = "https://api.weixin.qq.com/sns/jscode2session";

    /**
     * 转帐接口
     */
    private String payPersonUrl = "https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers";

    /**
     * 查询
     */
    private String payQueryUrl = "https://api.mch.weixin.qq.com/mmpaymkttransfers/gettransferinfo" ;

    /**
     * 获取accessToken
     */
    private String accessTokenUrl = "https://api.weixin.qq.com/cgi-bin/token" ;

    /**
     * 发送模板消息
     */
    private String sendTemplateMessage = "https://api.weixin.qq.com/cgi-bin/message/wxopen/template/send";

    /**
     * 公众号ID
     */
    private String appId = "wx570f34ccd5e1e73f";


    private String appSecret = "4c75cd7bd386345964a5eb22bdd830a1";

    /**
     * 微信支付分配的商户号
     */
    private String mchId;

    /**
     * 微信支付密匙
     */
    private  String paySecret;

    /**
     * 证书路径地址
     */
    private String certPath;

    /**
     * 支付描述
     */
    private String payDesc = "多多客提现到账";

    /**
     * 助力消息模板id
     */
    private String boostTemplateId = "Ubzs3OTcemgql2EGPolJIA0CVHQiY6Y0GTX3_fPZffY";

}
