package com.bxm.shop.controllers;

import com.bxm.shop.common.exception.EnhanceResultModel;
import com.bxm.shop.facade.model.boost.BoostDetailVo;
import com.bxm.shop.facade.model.boost.CreateBoostRo;
import com.bxm.shop.facade.model.goods.FreeGoodsVo;
import com.bxm.shop.service.BoostService;
import com.bxm.warcar.utils.response.ResultModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author yirenjie
 * createDate:  2018/12/20
 */
@RequestMapping("/boost")
@RestController
@Slf4j
public class BoostController {

    @Resource
    private BoostService boostService;

    @RequestMapping("/goodsList")
    public ResultModel<FreeGoodsVo> list(String openid) {
        ResultModel<FreeGoodsVo> resultModel = new EnhanceResultModel<>();
        resultModel.setReturnValue(boostService.list(openid));
        return resultModel;
    }

    @RequestMapping("/detail")
    public ResultModel<BoostDetailVo> detail(String openid, Long boostId) {
        ResultModel<BoostDetailVo> resultModel = new EnhanceResultModel<>();
        resultModel.setReturnValue(boostService.getDetail(openid, boostId));
        return resultModel;
    }

    @RequestMapping("/createBoost")
    public ResultModel<Long> createBoost(@RequestBody CreateBoostRo createBoostRo) {
        ResultModel<Long> resultModel = new EnhanceResultModel<>();
        resultModel.setReturnValue(boostService.createBoost(createBoostRo));
        return resultModel;
    }

    @RequestMapping("/boost")
    public ResultModel boost(String openid, Long boostId){
        boostService.boost(openid, boostId);
        return new EnhanceResultModel();
    }

}
