package com.bxm.shop.controllers;

import com.bxm.shop.facade.model.counter.CounterDto;
import com.bxm.shop.service.CounterService;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/counter")
public class CounterController {

    @Autowired
    private CounterService counterService;

    @RequestMapping("/count")
    public ResultModel count(@RequestBody CounterDto dto){
        ResultModel resultModel = new ResultModel();
        int save = counterService.save(dto);
        if(save != 1){
            resultModel.setSuccessed(Boolean.FALSE);
        }
        return resultModel;
    }

}
