package com.bxm.shop.controllers;

import com.bxm.shop.common.exception.EnhanceResultModel;
import com.bxm.shop.common.exception.ResponseCodeType;
import com.bxm.shop.facade.model.common.CommonDto;
import com.bxm.shop.facade.model.goods.GoodsVo;
import com.bxm.shop.service.FavoriteService;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/favorite")
public class FavoriteController {

    @Autowired
    private FavoriteService favoriteService;

    @RequestMapping("/add")
    public ResultModel add(@RequestBody  CommonDto dto){
        ResultModel rs = new ResultModel();
        int save = favoriteService.save(dto);
        if(save == 0){
            rs.setSuccessed(Boolean.FALSE);
            rs.setErrorCode(ResponseCodeType.SYSTEM_ERROR.getErrorCode());
            rs.setErrorDesc(ResponseCodeType.SYSTEM_ERROR.getErrorMsg());
        }
        return rs;
    }


    @RequestMapping("/cancel")
    public ResultModel cancel(@RequestBody CommonDto dto){
        ResultModel rs = new ResultModel();
        int cancel = favoriteService.cancel(dto);
        if(cancel == 0){
            rs.setSuccessed(Boolean.FALSE);
            rs.setErrorCode(ResponseCodeType.SYSTEM_ERROR.getErrorCode());
            rs.setErrorDesc(ResponseCodeType.SYSTEM_ERROR.getErrorMsg());
        }
        return rs;
    }

    @RequestMapping("/list")
    public ResultModel<List<GoodsVo>> list(String openid) {
        ResultModel<List<GoodsVo>> result = new EnhanceResultModel<>();
        result.setReturnValue(favoriteService.listFavorite(openid));
        return result;
    }


}
