package com.bxm.shop.controllers;

import com.bxm.shop.common.exception.ResponseCodeType;
import com.bxm.shop.config.WechatConfig;
import com.bxm.shop.facade.model.order.OrderDto;
import com.bxm.shop.facade.model.user.UserDto;
import com.bxm.shop.facade.model.user.UserVo;
import com.bxm.shop.service.UserService;
import com.bxm.shop.wxpay.WxPayUtil;
import com.bxm.shop.wxpay.dto.PayPerson;
import com.bxm.shop.wxpay.dto.TransferinfoDto;
import com.bxm.shop.wxpay.dto.TransferinfoReturn;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/user")
public class UserController {

    @Autowired
    private UserService userService;

    @Autowired
    private WechatConfig wechatConfig;
    /**
     * 用户登录
     * wx登录
     * @param dto
     * @return
     */
    @RequestMapping(value = "/login")
    public ResultModel login(@RequestBody UserDto dto){
        ResultModel rs = new ResultModel();
        UserVo vo = userService.login(dto);
        rs.setReturnValue(vo);
        return rs;
    }


    /**
     * 更新用户信息
     * @param dto
     * @return
     */
    @RequestMapping(value = "/update", method = { RequestMethod.POST})
    public ResultModel update(@RequestBody UserDto dto){
        ResultModel rs = new ResultModel();
        userService.update(dto);
        return rs;
    }


    @RequestMapping("test")
    public ResultModel test(){
        ResultModel rs = new  ResultModel();
        TransferinfoDto transferinfoDto = new TransferinfoDto();
        transferinfoDto.setAppid(wechatConfig.getAppId());
        transferinfoDto.setMch_id(wechatConfig.getMchId());
        transferinfoDto.setPartner_trade_no("000000000000442018112710310502");
        try {
            TransferinfoReturn transferinfoReturn = WxPayUtil.payQuery(transferinfoDto, wechatConfig);
            rs.setReturnValue(transferinfoReturn);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return rs;
    }

}
