package com.bxm.shop.controllers;

import com.bxm.shop.facade.model.wallet.WalletDto;
import com.bxm.shop.service.WalletSerive;
import com.bxm.warcar.utils.response.ResultModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/wallet")
@Slf4j
public class WalletController {

    @Autowired
    private WalletSerive walletSerive;


    /**
     * 提现接口
     * @return
     */
    @RequestMapping("/withdraw")
    public ResultModel withdraw(@RequestBody WalletDto dto){
        ResultModel rs = walletSerive.withdraw(dto);
        return rs;
    }

    /**
     * 钱包信息
     * @param dto
     * @return
     */
    @RequestMapping("/info")
    public ResultModel info(@RequestBody WalletDto dto){
        ResultModel rs = new ResultModel();
        rs.setReturnValue(walletSerive.info(dto));
        return rs;
    }

    @RequestMapping(value = "/payRetry", method = { RequestMethod.POST})
    public ResultModel payRetry(){
        ResultModel rs = new ResultModel();
        try {
            walletSerive.payRetry();
        }catch (Exception e){
            log.error("重试失败：",e);
            rs.setSuccessed(Boolean.FALSE);
        }
        return rs;
    }
}
