package com.bxm.shop.interceptors.profit;

import com.bxm.shop.common.exception.RedisConstants;
import com.bxm.shop.common.exception.ResponseCodeType;
import com.bxm.shop.common.exception.ShopsException;
import com.bxm.shop.dal.mapper.BoostMapper;
import com.bxm.shop.dal.mapper.UserMapper;
import com.bxm.shop.integration.config.PingduoduoConfig;
import com.bxm.shop.model.user.dao.UserDao;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;

/**
 * @author yirenjie
 * createDate:  2018/12/24
 */
@Service
public class FreeOrderInterceptor extends AbstractInterceptor {

    @Autowired
    @Qualifier("jedisUpdater")
    protected Updater updater;

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Resource
    private PingduoduoConfig pingduoduoConfig;

    @Resource
    private BoostMapper boostMapper;

    @Resource
    private UserMapper userMapper;

    /**
     * 业务处理
     *
     * @param invocation
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    protected void doIntercept(Invocation invocation) {
        ProfitRequestModel requestModel = (ProfitRequestModel) invocation.getRequestModel();
        Long orderId = requestModel.getOrderDao().getId();
        String freeKey = String.format(RedisConstants.HANDING_FREE_ORDER, orderId);
        try {

            boolean hasSold = false;
            for (Integer status : pingduoduoConfig.getSold()) {
                if (status.equals(requestModel.getPddOrderInfo().getOrderStatus())) {
                    hasSold = true;
                    break;
                }
            }
            if (!hasSold) {
                return;
            }

            if (StringUtils.isNotBlank(stringRedisTemplate.opsForValue().getAndSet(freeKey, ""))) {
                if (!boostMapper.push2UsedByOpenid(requestModel.getUserDao().getOpenid())) {
                    throw new ShopsException(ResponseCodeType.OPERATION_NOT_EXECUTED);
                }
                UserDao info = userMapper.findByOpenid(requestModel.getUserDao().getOpenid());
                info.setFreeTimes(info.getFreeTimes() + 1);
                info.setModifyTime(new Date());
                if (userMapper.updateByOpenid(info) != 1) {
                    throw new ShopsException(ResponseCodeType.OPERATION_NOT_EXECUTED);
                }
                updater.hupdate(RedisConstants.User.getUserInfo(), info.getOpenid(), info);
            }
        } catch (Exception e) {
            stringRedisTemplate.opsForValue().set(freeKey, "0");
            throw e;
        }

    }
}
