package com.bxm.shop.interceptors.profit;

import com.bxm.shop.facade.model.order.PddOrderInfo;
import com.bxm.shop.integration.RebateConfig;
import com.bxm.shop.model.order.dao.OrderDao;
import com.bxm.shop.model.user.dao.UserDao;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

/**
 * 收益计算模型实体
 * @author  bcc
 */
@Setter
@Getter
@ToString
public class ProfitRequestModel implements Serializable {

    /**
     * 拼多多订单信息
     */
    private PddOrderInfo pddOrderInfo;

    /**
     * 返现配置
     */
    private RebateConfig rebateConfig;

    /**
     * 数据库虚拟订单表
     */
    private OrderDao orderDao;

    /**
     * 用户信息
     */
    private UserDao userDao;

    /**
     * 收益有影响的人
     */
    private Set<String> profitRelatedUser = new HashSet<>();

}
