package com.bxm.shop.interceptors.profit;

import com.bxm.shop.common.enums.ProfitTypeEnum;
import com.bxm.shop.common.utils.CustomParameterUtils;
import com.bxm.shop.model.user.dao.UserDao;
import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * 分享返利处理
 * @author bcc
 */
@Component
public class ShareInterceptor extends AbstractProfitInterceptor {

    @Override
    public String getProfittype() {
        return ProfitTypeEnum.SHARE.getCode();
    }

    @Override
    public Long getProfitAmount(ProfitRequestModel requestModel) {
        long promotionAmount = 0L;
        if(null != requestModel.getPddOrderInfo().getPromotionAmount()){
            promotionAmount = requestModel.getPddOrderInfo().getPromotionAmount();
        }
        return promotionAmount * requestModel.getRebateConfig().getShare() / 100;
    }

    @Override
    public String getProfitOwner(ProfitRequestModel requestModel) {
        return requestModel.getOrderDao().getShareOpenid();
    }

    @Override
    public Boolean needSaveOrUpdate(ProfitRequestModel requestModel) {
        String shareOpenid = requestModel.getOrderDao().getShareOpenid();
        //存在分享用户，且分享返利金额大于0
        if(StringUtils.isNotBlank(shareOpenid)&&
                requestModel.getRebateConfig().getShare()>0 && null != requestModel.getPddOrderInfo().getPromotionAmount() &&
                requestModel.getPddOrderInfo().getPromotionAmount()>0){
            return true;
        }
        return false;
    }

}