package com.bxm.shop.service;

import com.bxm.shop.facade.model.common.Page;
import com.bxm.shop.facade.model.order.OrderDto;
import com.bxm.shop.facade.model.order.OrderSearchVo;
import com.bxm.shop.facade.model.order.OrderVo;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 订单service
 * @author bcc
 */
public interface OrderService {

    OrderVo add(OrderDto dto);

    /**
     * 删除超过一定时间未关联拼多多订单的虚拟订单
     * @param date
     */
    void deleteAbandonOrder(Date date);

    /**
     * 从拼多多同步订单
     * @param dto
     */
    void synchronizeOrder(OrderDto dto);

    /**
     * 统计已售商品数量
     * @param goodsId
     * @return
     */
    Map<String,Integer> statisticsSoldGoodsNum(List<String> goodsId);


    Page<OrderSearchVo> find(OrderDto dto);
}
