package com.bxm.shop.service;

import com.bxm.shop.facade.model.wallet.WalletDto;
import com.bxm.shop.facade.model.wallet.WalletVo;
import com.bxm.shop.model.wallet.dao.WalletRedisDao;
import com.bxm.warcar.utils.response.ResultModel;

public interface WalletSerive {

    /**
     * 提现接口
     * @return true
     */
    ResultModel withdraw(WalletDto dto);

    /**
     * 提现接口
     * @param dto
     * @return
     */
    WalletVo info(WalletDto dto);

    /**
     * 按openid计算收益并缓存
     * @param openid
     * @return
     */
    void cacheProfit(String openid);

    /**
     * 定时任务
     * 支付失败的提现申请重试
     */
    void payRetry() throws Exception;
}
