package com.bxm.shop.service.impl;

import com.bxm.shop.common.exception.RedisConstants;
import com.bxm.shop.dal.mapper.FavoriteMapper;
import com.bxm.shop.facade.model.common.CommonDto;
import com.bxm.shop.facade.model.goods.GoodsVo;
import com.bxm.shop.integration.pdd.PddGoodsIntegration;
import com.bxm.shop.model.favorite.dao.FavoriteDao;
import com.bxm.shop.model.goods.vo.Good;
import com.bxm.shop.service.FavoriteService;
import com.bxm.shop.service.GoodsService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
public class FavoriteServiceImpl implements FavoriteService {

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    private FavoriteMapper favoriteMapper;

    @Resource
    private PddGoodsIntegration pddGoodsIntegration;

    @Resource
    private GoodsService goodsService;

    @Override
    public int save(CommonDto dto) {
        String redisKey = RedisConstants.Favorite.getMyFavorite(dto.getOpenid()).generateKey();
        if (stringRedisTemplate.opsForZSet().rank(redisKey, dto.getGoodsId()) != null) {
            // 已存在
            return 1;
        }
        FavoriteDao dao = new FavoriteDao();
        dao.setCreateTime(new Date());
        dao.setGoodsId(dto.getGoodsId());
        dao.setOpenid(dto.getOpenid());
        int save = favoriteMapper.save(dao);
        //更新缓存
        stringRedisTemplate.opsForZSet().add(redisKey, dto.getGoodsId(), System.currentTimeMillis() / 1000);
        return save;
    }

    @Override
    public int cancel(CommonDto dto) {
        int delete = favoriteMapper.delete(dto.getOpenid(), dto.getGoodsId());
        //删除缓存
        stringRedisTemplate.opsForZSet()
                .remove(RedisConstants.Favorite.getMyFavorite(dto.getOpenid()).generateKey(), dto.getGoodsId());
        return delete;
    }

    @Override
    public List<GoodsVo> listFavorite(String openid) {
        Set<String> goodsIds = stringRedisTemplate.opsForZSet()
                .reverseRange(RedisConstants.Favorite.getMyFavorite(openid).generateKey(), 0, -1);
        List<Good> goods = pddGoodsIntegration.queryGoodsList(new ArrayList<>(goodsIds));
        return goods.stream().map(good -> goodsService.trans2Vo(good, null, null))
                .collect(Collectors.toList());
    }
}
