package com.bxm.shop.service.impl;

import com.bxm.shop.common.exception.ResponseCodeType;
import com.bxm.shop.common.exception.ShopsException;
import com.bxm.shop.dal.Feedback;
import com.bxm.shop.dal.base.Example;
import com.bxm.shop.dal.mapper.FeedbackMapper;
import com.bxm.shop.facade.model.feedback.FeedbackQueryRo;
import com.bxm.shop.facade.model.feedback.FeedbackVo;
import com.bxm.shop.facade.model.common.Page;
import com.bxm.shop.service.FeedbackService;
import org.apache.commons.lang3.StringUtils;
import org.dozer.Mapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author yirenjie
 * createDate:  2018/11/12
 */
@Service
public class FeedbackServiceImpl implements FeedbackService {

    @Resource
    private FeedbackMapper feedbackMapper;

    @Resource
    private Mapper mapper;

    @Override
    public boolean addFeedback(FeedbackVo feedback) {
        if (feedback == null) {
            throw new ShopsException(ResponseCodeType.PARAM_ILLEGAL);
        }
        return feedbackMapper.insertSelective(mapper.map(feedback, Feedback.class)) == 1;
    }

    @Override
    public Page<FeedbackVo> listFeedback(FeedbackQueryRo queryRo) {
        Example<Feedback> example = new Example<Feedback>() {
        };
        if (StringUtils.isNotBlank(queryRo.getKeyword())) {
            example.appendCriterion("proposal like ", "%" + queryRo.getKeyword() + "%");
        }
        Page<FeedbackVo> page = new Page<>();
        page.setTotal((long) feedbackMapper.countByExample(example));
        page.setPageNum(queryRo.getPageNum());
        page.setPageSize(queryRo.getPageSize());
        if (page.getTotal() == 0) {
            return page;
        }
        List<Feedback> feedbackList = feedbackMapper.selectByExampleAndPage(example, queryRo.getPageNum(), queryRo.getPageSize());
        page.setList(feedbackList.stream().map(feedback -> mapper.map(feedback, FeedbackVo.class)).collect(Collectors.toList()));
        return page;
    }
}
