package com.bxm.shop.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shop.common.exception.RedisConstants;
import com.bxm.shop.dal.Tag;
import com.bxm.shop.dal.base.Example;
import com.bxm.shop.dal.mapper.TagMapper;
import com.bxm.shop.facade.model.tag.TagVo;
import com.bxm.shop.service.TagService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author yirenjie
 * createDate:  2018/11/13
 */
@Service
public class TagServiceImpl implements TagService {

    @Resource
    private TagMapper tagMapper;

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public List<TagVo> getTagsByParentId() {
        String json = stringRedisTemplate.opsForValue().get(RedisConstants.TAG_CONFIG_KEY);
        if (StringUtils.isNotBlank(json)){
            return JSONObject.parseArray(json, TagVo.class);
        }
        Example<Tag> example = new Example<Tag>() {
        };
        example.appendCriterion("visible = ", 1);
        List<Tag> tags = tagMapper.selectByExample(example);
        List<TagVo> result = treeify(tags);
        stringRedisTemplate.opsForValue().set(RedisConstants.TAG_CONFIG_KEY, JSONObject.toJSONString(result));
        return result;
    }

    private List<TagVo> treeify(List<Tag> tags) {
        Map<Long, TagVo> parentMap = new HashMap<>();
        for (Iterator<Tag> iterator = tags.iterator(); iterator.hasNext(); ) {
            Tag tag = iterator.next();
            if (tag.getParentId() == 0 || !tag.getVisible()) {
                iterator.remove();
                parentMap.put(tag.getId(), trans2Vo(tag));
            }
        }

        for (Tag tag : tags) {
            TagVo parent = parentMap.get(tag.getParentId());
            if (parent != null) {
                TagVo vo = trans2Vo(tag);
                vo.setParentName(parent.getOptName());
                parent.getSubTags().add(vo);
            }
        }
        return parentMap.values().stream()
                .peek(tagVo -> tagVo.getSubTags().sort(Comparator.comparingInt(TagVo::getOrder)))
                .sorted(Comparator.comparingInt(TagVo::getOrder)).collect(Collectors.toList());
    }

    private TagVo trans2Vo(Tag tag) {
        TagVo tagVo = new TagVo();
        tagVo.setOptId(tag.getId());
        tagVo.setOptName(tag.getName());
        tagVo.setParentOptId(tag.getParentId());
        tagVo.setOrder(tag.getOrder());
        tagVo.setImgUrl(tag.getImageUrl());
        return tagVo;
    }

}
