package com.bxm.shop.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.shop.common.constants.WeChatConstants;
import com.bxm.shop.common.exception.RedisConstants;
import com.bxm.shop.common.utils.InviteCodeUtils;
import com.bxm.shop.common.utils.OkHttpUtils;
import com.bxm.shop.config.WechatConfig;
import com.bxm.shop.dal.mapper.UserMapper;
import com.bxm.shop.facade.model.user.UserDto;
import com.bxm.shop.facade.model.user.UserVo;
import com.bxm.shop.model.user.dao.UserDao;
import com.bxm.shop.model.user.dto.WechatLoginReturn;
import com.bxm.shop.service.UserService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import org.apache.commons.lang.StringUtils;
import org.dozer.Mapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Service
@Transactional(rollbackFor = Exception.class)
public class UserServiceImpl implements UserService {

    @Autowired
    private WechatConfig wechatConfig;

    @Autowired
    private UserMapper userMapper;

    @Autowired
    private Mapper mapper;

    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    @Autowired
    @Qualifier("jedisUpdater")
    protected Updater updater;

    @Override
    public UserVo login(UserDto dto) {
        UserVo vo = new UserVo();
        WechatLoginReturn loginObj = wechartLogin(dto.getCode()) ;
        if(null == loginObj.getOpenid()){
            return vo;
        }
        vo.setOpenid(loginObj.getOpenid());
        vo.setUnionid(loginObj.getUnioinid());
        vo.setSessionId(loginObj.getSessionkey());
        //验证是否为新用户
        UserDao info = fetcher.hfetch(RedisConstants.User.getUserInfo(),vo.getOpenid(),UserDao.class);
        if(null == info){
            vo.setNewUser(true);
            info = new UserDao();
            mapper.map(dto,info);
            info.setCreateTime(new Date());
            info.setOpenid(vo.getOpenid());
            info.setUnionid(vo.getUnionid());
            //有邀请码时需要保留关联关系
            if(StringUtils.isNotBlank(dto.getInviteCode())) {
                UserDao parentUser = userMapper.findByInviteCode(dto.getInviteCode());
                if(null != parentUser){
                    info.setParentOpenid(parentUser.getOpenid());
                    info.setParentUnionid(parentUser.getUnionid());
                    info.setGrandparentOpenid(parentUser.getParentOpenid());
                    info.setGrandparentUnionid(parentUser.getGrandparentUnionid());
                }
            }
            userMapper.save(info);
            //生成邀请码
            String inviteCode = InviteCodeUtils.generate(info.getId());
            info.setInviteCode(inviteCode);
            userMapper.updateByOpenid(info);
        }
        updater.hupdate(RedisConstants.User.getUserInfo(),info.getOpenid(),info);
        //保存用户session信息
        updater.update(RedisConstants.User.getSessionId(vo.getOpenid(),vo.getSessionId()),"",RedisConstants.User.SESSION_TIME);
        vo.setInviteCode(info.getInviteCode());
        vo.setMobile(info.getMobile());
        return vo;
    }

    @Override
    public int update(UserDto dto) {
        UserDao userDao = new UserDao();
        mapper.map(dto,userDao);
        userDao.setModifyTime(new Date());
        int updateCount = userMapper.updateByOpenid(userDao);
        UserDao info = userMapper.findByOpenid(dto.getOpenid());
        updater.hupdate(RedisConstants.User.getUserInfo(),info.getOpenid(),info);
        return updateCount;
    }

    /**
     * 微信登录
     * 通过返回对象的openid判断是否登录成功
     * @param code
     * @return
     */
    private WechatLoginReturn wechartLogin(String code){
        Map<String,String> params = new HashMap<>();
        params.put(WeChatConstants.Param.APP_ID,wechatConfig.getAppId());
        params.put(WeChatConstants.Param.SECRET,wechatConfig.getAppSecret());
        params.put(WeChatConstants.Param.JS_CDOE,code);
        params.put(WeChatConstants.Param.GRANT_TYPE,WeChatConstants.Param.AUTH_CODE);
        String response = null;
        try {
            response = OkHttpUtils.post(wechatConfig.getJscode2sessionUrl(),params);
        } catch (IOException e) {
        }
        WechatLoginReturn wechartLogin = new WechatLoginReturn();
        if(null != response) {
            JSONObject obj = JSON.parseObject(response);
            if(null != obj && obj.getString(WeChatConstants.Param.OPENID) != null){
                wechartLogin.setOpenid(obj.getString(WeChatConstants.Param.OPENID));
                wechartLogin.setUnioinid(obj.getString(WeChatConstants.Param.UNIONID));
                wechartLogin.setSessionkey(obj.getString(WeChatConstants.Param.SESSION_KEY));
            }
        }
        return wechartLogin;
    }





}
