package com.bxm.shop.service.impl;

import com.bxm.shop.dal.mapper.UserShareMapper;
import com.bxm.shop.facade.model.common.CommonDto;
import com.bxm.shop.model.user.dao.UserShareDao;
import com.bxm.shop.service.UserShareService;
import org.dozer.Mapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Service
@Transactional(rollbackFor = Exception.class)
public class UserShareServiceImpl implements UserShareService {

    @Autowired
    private Mapper mapper;

    @Autowired
    private UserShareMapper userShareMapper;

    @Override
    public Long save(CommonDto dto) {
        Long id = findShareIdByOpenidAndGoodsId(dto.getOpenid(), dto.getGoodsId());
        if(id != null && id >0){
            return  id;
        }
        UserShareDao dao = new UserShareDao();
        mapper.map(dto,dao);
        dao.setCreateTime(new Date());
        userShareMapper.save(dao);
        return dao.getId() ;
    }

    private Long findShareIdByOpenidAndGoodsId(String openid, String goodsId) {
        return userShareMapper.findByOpenidAndGoodsId(openid,goodsId);
    }
}
