package com.bxm.shop.utils;

import com.bxm.shop.facade.model.common.Page;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * 逻辑分页工具类
 * @author bcc
 * @version V1.0.0
 */
public final class LogicalPageUtils {
	private LogicalPageUtils(){}
	
	/**
	 * list是全量信息时，根据分页信息截取从list中返回数据
	 * @param page
	 * @param list
	 * @return
	 */
	public static Page getPageList(Page page, List<? extends Object> list) {
		if(null == page) {
			page = new Page();
		}
		page.setTotal(Long.valueOf(list.size()));
		int toIndex = page.getPageNum()*page.getPageSize()>page.getTotal()?page.getTotal().intValue():page.getPageNum()*page.getPageSize();
		int startIndex = (page.getPageNum() - 1) * page.getPageSize();
		if( startIndex >=page.getTotal() || startIndex > toIndex) {
			page.setList(Lists.newArrayList());
			return page;
		}
		List<? extends Object> subList = list.subList(startIndex, toIndex);
		page.setList(subList);
		return page;
	}
	 
	
}
