package com.bxm.shop.utils;

import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.StringRedisTemplate;

import java.util.List;

/**
 * @author yirenjie
 * createDate:  2019/1/9
 */
@Slf4j
public class RedisLock {

    private StringRedisTemplate stringRedisTemplate;

    public RedisLock(StringRedisTemplate stringRedisTemplate){
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public void lock(final String key) {
        while (true) {
            if (tryLock(key, 60 * 3L)) {
                return;
            } else {
                try {
                    Thread.sleep(500);
                } catch (final InterruptedException e) {
                    throw new RuntimeException("获取锁失败", e);
                }
            }
        }
    }

    public boolean tryLock(final String key, final Long expireSecond) {
        if (key == null || key.equals("")) {
            throw new RuntimeException("key 不能为空");
        }

        Boolean result = stringRedisTemplate.execute((RedisConnection connection) -> {
            final Boolean result1 = connection.setNX(key.getBytes(), String.valueOf(System.currentTimeMillis()).getBytes());
            if (result1) {
                connection.expire(key.getBytes(), expireSecond);
            }
            return result1;
        });
        if (result == null) {
            log.error("调用redis 发现Null, 可能无法连接redis.");
            result = Boolean.FALSE;
        }

        return result;
    }


    public void unlock(final String key) {
        if (key == null || key.equals("")) {
            throw new RuntimeException("key 不能为空");
        }

        stringRedisTemplate.execute((RedisConnection connection) -> {
            connection.multi();
            connection.del(key.getBytes());
            final List<Object> list = connection.exec();
            return (Long) list.get(0);
        });

    }

}
