package com.bxm.shop.utils;


import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import com.thoughtworks.xstream.mapper.MapperWrapper;

/**
 * xml bean 互转类
 * @author
 * @depend xstream
 *食用说明：
 * // 别名注解，这个别名就是XML文档中的元素名，Java的属性名不一定要与别名一致
    @XStreamAlias("name")
    // 属性注解，此price就是book的属性，在XML中显示为：<book price="108">
    @XStreamAsAttribute()
 */
public class XmlFactory {

	/**
	 * 对象转化为xml
	 * 
	 * @param obj
	 * @return
	 * @throws Exception
	 */
	public static String toXml(Object obj) throws Exception {
		XStream xstream =  new XStream(new DomDriver("UTF-8", new XmlFriendlyNameCoder("__", "_")));
		xstream.processAnnotations(obj.getClass()); // 识别obj类中的注解
		return xstream.toXML(obj);
	}

	/**
	 * xml转bean
	 * @param xmlStr
	 * @param cls
	 * @return
	 * @throws Exception
	 */
	public static <T> T toBean(String xmlStr, Class<T> cls) throws Exception  {
		XStream xstream = getXStream(new DomDriver());
		Class<?> superClass = cls.getSuperclass();
		while(superClass != null){
			xstream.processAnnotations(superClass);
			superClass = superClass.getSuperclass();
		}
		xstream.processAnnotations(cls);
		@SuppressWarnings("unchecked")
		T t = (T) xstream.fromXML(xmlStr);
		return t;
	}
	
	/**
	 * 装换java bean 过滤不能识别的字段
	 * @author liguang.jin
	 *
	 */
	public static XStream getXStream(DomDriver domDriver){
		XStream xstream = new XStream(domDriver) {
		    @Override
		    protected MapperWrapper wrapMapper(MapperWrapper next) {
		        return new MapperWrapper(next) {
		            @Override
		            public boolean shouldSerializeMember(Class definedIn, String fieldName) {
		                if (definedIn == Object.class) {
		                    return false;
		                }
		                return super.shouldSerializeMember(definedIn, fieldName);
		            }
		        };
		    }
		};
		return xstream;
	}

}


