package com.bxm.shop.wxpay.dto;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 商户向个人转账返回code
 * @author liguang.jin
 *
 */
@XStreamAlias("xml")
public class PayPersonReturn {
	@XStreamOmitField  
	private Logger logger = LoggerFactory.getLogger(PayPersonReturn.class);
	
	@XStreamAlias("return_code")
	private String returnCode; //SUCCESS/FAIL 此字段是通信标识，非交易标识，交易是否成功需要查看result_code来判断
	@XStreamAlias("return_msg")
	private String returnMsg;  //返回信息，如非空，为错误原因 签名失败 参数格式校验错误
	@XStreamAlias("result_code")
	private String resultCode;  //业务结果 SUCCESS/FAIL
	@XStreamAlias("err_code")
	private String errCode;  // 	错误码信息
	@XStreamAlias("err_code_des")
	private String errCodeDes; // 错误代码描述 结果信息描述
	@XStreamAlias("mch_appid") 
	private String mch_appid; //微信分配的公众账号ID（企业号corpid即为此appId）
	@XStreamAlias("mchid") 
	private String mchid; //微信支付分配的终端设备号，
	@XStreamAlias("nonce_str") 
	private String nonce_str; //随机字符串，不长于32位
	@XStreamAlias("payment_no")
	private String paymentNo; //微信付款单号
	@XStreamAlias("payment_time")
	private String paymentTime; //付款时间


	public String getReturnCode() {
		return returnCode;
	}
	public void setReturnCode(String returnCode) {
		this.returnCode = returnCode;
	}
	public String getReturnMsg() {
		return returnMsg;
	}
	public void setReturnMsg(String returnMsg) {
		this.returnMsg = returnMsg;
	}
	public String getResultCode() {
		return resultCode;
	}
	public void setResultCode(String resultCode) {
		this.resultCode = resultCode;
	}
	public String getErrCode() {
		return errCode;
	}
	public void setErrCode(String errCode) {
		this.errCode = errCode;
	}
	public String getErrCodeDes() {
		return errCodeDes;
	}
	public void setErrCodeDes(String errCodeDes) {
		this.errCodeDes = errCodeDes;
	}
	public Logger getLogger() {
		return logger;
	}
	public void setLogger(Logger logger) {
		this.logger = logger;
	}
	public String getMch_appid() {
		return mch_appid;
	}
	public void setMch_appid(String mch_appid) {
		this.mch_appid = mch_appid;
	}
	public String getMchid() {
		return mchid;
	}
	public void setMchid(String mchid) {
		this.mchid = mchid;
	}
	public String getNonce_str() {
		return nonce_str;
	}
	public void setNonce_str(String nonce_str) {
		this.nonce_str = nonce_str;
	}

	public String getPaymentNo() {
		return paymentNo;
	}

	public void setPaymentNo(String paymentNo) {
		this.paymentNo = paymentNo;
	}

	public String getPaymentTime() {
		return paymentTime;
	}

	@Override
	public String toString() {
		return "PayPersonReturn{" +
				"returnCode='" + returnCode + '\'' +
				", returnMsg='" + returnMsg + '\'' +
				", resultCode='" + resultCode + '\'' +
				", errCode='" + errCode + '\'' +
				", errCodeDes='" + errCodeDes + '\'' +
				", mch_appid='" + mch_appid + '\'' +
				", mchid='" + mchid + '\'' +
				", nonce_str='" + nonce_str + '\'' +
				", paymentNo='" + paymentNo + '\'' +
				", paymentTime='" + paymentTime + '\'' +
				'}';
	}
	public void setPaymentTime(String paymentTime) {
		this.paymentTime = paymentTime;
	}
}
