package com.bxm.shop.wxpay.dto;

import com.bxm.shop.config.WechatConfig;
import com.bxm.shop.wxpay.WxPayUtil;
import com.thoughtworks.xstream.annotations.XStreamAlias;

import javax.xml.bind.annotation.XmlRootElement;
import java.io.UnsupportedEncodingException;

/**
 * 微信企业付款查询对象
 */
@XStreamAlias("xml")
public class TransferinfoDto {
    @XStreamAlias("nonce_str")
    private String nonceStr;  //随机字符串，不长于32位
    @XStreamAlias("sign")
    private String sign;
    @XStreamAlias("partner_trade_no")
    private String partner_trade_no; //商户订单号，需保持唯一性
    @XStreamAlias("appid")
    private String appid;
    @XStreamAlias("mch_id")
    private String mch_id;

    public void createSign(WechatConfig config) throws IllegalArgumentException, IllegalAccessException, UnsupportedEncodingException {
        this.sign = WxPayUtil.createSign(this, config.getPaySecret(),true);
    }
    public String getNonceStr() {
        return nonceStr;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getPartner_trade_no() {
        return partner_trade_no;
    }

    public void setPartner_trade_no(String partner_trade_no) {
        this.partner_trade_no = partner_trade_no;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getMch_id() {
        return mch_id;
    }

    public void setMch_id(String mch_id) {
        this.mch_id = mch_id;
    }
}
