/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.jobs;

import com.bxm.shop.common.utils.ExceptionPrintUtils;
import com.bxm.shop.integration.WalletServiceIntegration;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PayRetryJob {
    private static final Logger log = LoggerFactory.getLogger(PayRetryJob.class);
    @Autowired
    private MessageSender messageSender;
    @Autowired
    private WalletServiceIntegration walletServiceIntegration;

    public void payRetry() {
        log.info("-------- Start payRetry-------, {}");
        Long start = System.currentTimeMillis();
        try {
            this.walletServiceIntegration.payRetry();
        }
        catch (Exception e) {
            Message msg = new Message();
            msg.setContent("payRetry Error:" + ExceptionPrintUtils.printStackTraceToString((Throwable)e));
            this.messageSender.send2(msg);
            log.error("payRetry error", (Throwable)e);
        }
        log.info("payRetry finished in {} ms", (Object)(System.currentTimeMillis() - start));
    }
}

