package com.bxm.shop.controller;

import com.bxm.shop.jobs.DeleteAbandonOrderJob;
import com.bxm.shop.jobs.PayRetryJob;
import com.bxm.shop.jobs.SynchronizeOrderJob;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/12/27 17:18
 */
@RequestMapping("scheduled")
@RestController
public class ScheduledController {

	@Autowired
	DeleteAbandonOrderJob  deleteAbandonOrderJob;
	@Autowired
	PayRetryJob payRetryJob;
	@Autowired
	SynchronizeOrderJob synchronizeOrderJob;


	@RequestMapping("/deleteAbandonOrder")
	public ResultModel deleteAbandonOrder(){
		deleteAbandonOrderJob.deleteAbandonOrder();
		return ResultModelFactory.SUCCESS();
	}
	@RequestMapping("/payRetry")
	public ResultModel payRetry(){
		payRetryJob.payRetry();
		return ResultModelFactory.SUCCESS();
	}
	@RequestMapping("/synchronizeOrder")
	public ResultModel synchronizeOrder(){
		synchronizeOrderJob.synchronizeOrder();
		return ResultModelFactory.SUCCESS();
	}
	@RequestMapping("/synchronizeOrder2")
	public ResultModel synchronizeOrder2(){
		synchronizeOrderJob.synchronizeOrder2();
		return ResultModelFactory.SUCCESS();
	}
}
