package com.bxm.shop.jobs;

import com.bxm.shop.common.utils.ExceptionPrintUtils;
import com.bxm.shop.facade.model.order.OrderDto;
import com.bxm.shop.integration.OrderServiceIntegration;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import java.util.Date;

/**
 * 删除废弃的虚拟订单
 * 虚拟订单创建后一段时间没有关联拼多多订单，
 * 废弃订单
 * @author
 */
@Component
@Slf4j
public class DeleteAbandonOrderJob {

    @Autowired
    private MessageSender messageSender;

    @Autowired
    private OrderServiceIntegration orderServiceIntegration;

    /**
     * 每天两点执行删除废弃虚拟订单
     * 凌晨两点执行
     */
    @Scheduled(cron = "0 0 2 * * ?")
    public void deleteAbandonOrder(){
        log.info("-------- Start deleteAbandonOrder-------, {}");
        Long start = System.currentTimeMillis();
        OrderDto dto=new OrderDto();
        dto.setDate(DateUtils.addDays(new Date(),-30));
        try {
            orderServiceIntegration.deleteAbandonOrder(dto);
        }catch (Exception e){
            Message msg = new Message();
            msg.setContent("deleteAbandonOrder Error:"+ExceptionPrintUtils.printStackTraceToString(e));
            messageSender.send2(msg);
            log.error("deleteAbandonOrder error",e);
        }
        log.info("deleteAbandonOrder finished in {} ms", (System.currentTimeMillis()-start));
    }



}
