package com.bxm.shop.jobs;

import com.bxm.shop.common.utils.ExceptionPrintUtils;
import com.bxm.shop.integration.WalletServiceIntegration;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * 支付重试定时任务
 * @author bcc
 */
@Component
@Slf4j
public class PayRetryJob {

    @Autowired
    private MessageSender messageSender;

    @Autowired
    private WalletServiceIntegration walletServiceIntegration;

    /**
     * 每5分钟同步一次
     */
    @Scheduled(cron = "0 0/5 * * * ?")
    public void payRetry(){
        log.info("-------- Start payRetry-------, {}");
        Long start = System.currentTimeMillis();
        try {
            walletServiceIntegration.payRetry();
        }catch (Exception e){
            Message msg = new Message();
            msg.setContent("payRetry Error:"+ExceptionPrintUtils.printStackTraceToString(e));
            messageSender.send2(msg);
            log.error("payRetry error",e);
        }
        log.info("payRetry finished in {} ms", (System.currentTimeMillis()-start));
    }

}
