package com.bxm.shop.jobs;

import com.bxm.shop.common.utils.ExceptionPrintUtils;
import com.bxm.shop.facade.model.order.OrderDto;
import com.bxm.shop.integration.OrderServiceIntegration;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class SynchronizeOrderJob {

    @Autowired
    private MessageSender messageSender;

    @Autowired
    private OrderServiceIntegration orderServiceIntegration;

    /**
     * 每分钟同步一次
     */
    @Scheduled(cron = "0/30 * * * * ?")
    public void synchronizeOrder(){
        log.info("-------- Start synchronizeOrder-------, {}");
        Long start = System.currentTimeMillis();
        OrderDto dto=new OrderDto();
        //同步最近2分钟的数据
        dto.setStartUpdateTime(System.currentTimeMillis()/1000-60*2);
        dto.setEndUpdateTime(System.currentTimeMillis()/1000);
        dto.setPageSize(50);
        dto.setPageNum(1);
        try {
            orderServiceIntegration.synchronizeOrder(dto);
        }catch (Exception e){
            Message msg = new Message();
            msg.setContent("synchronizeOrder Error:"+ExceptionPrintUtils.printStackTraceToString(e));
            messageSender.send2(msg);
            log.error("synchronizeOrder error",e);
        }
        log.info("synchronizeOrder finished in {} ms", (System.currentTimeMillis()-start));
    }

    /**
     * 每10分钟同步一次订单;
     * 同步最近20分钟订单
     */
    @Scheduled(cron = "30 0/10 * * * ?")
    public void synchronizeOrder2(){
        log.info("-------- Start synchronizeOrder2-------, {}");
        Long start = System.currentTimeMillis();
        OrderDto dto=new OrderDto();
        //同步最近20分钟的数据
        dto.setStartUpdateTime(System.currentTimeMillis()/1000-20*60);
        dto.setEndUpdateTime(System.currentTimeMillis()/1000);
        dto.setPageSize(50);
        dto.setPageNum(1);
        try {
            orderServiceIntegration.synchronizeOrder(dto);
        }catch (Exception e){
            Message msg = new Message();
            msg.setContent("synchronizeOrder2 Error:"+ExceptionPrintUtils.printStackTraceToString(e));
            messageSender.send2(msg);
            log.error("synchronizeOrder2 error",e);
        }
        log.info("synchronizeOrder2 finished in {} ms", (System.currentTimeMillis()-start));
    }
}
