package com.bxm.shopping.integration;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;

import java.util.Objects;

/**
 * 风控校验接口
 * @author tangx
 * @date 2022/2/16 16:09
 */
@Slf4j
@Configuration
public class ChkRiskIntegration {

    @Autowired
    @Qualifier("orderRestTemplate")
    private RestTemplate restTemplate;

    public static final String requestUrl = "http://lxk.pancou.com:8008/card/szunicom/v2/chkRisk?appCode=4894";
    public static final String userId = "8";

    public static void main(String[] args) {
        ChkRiskIntegration chkRiskIntegration = new ChkRiskIntegration();
    }

    public void send(RequestObject requestObject) {
        processRequest(requestObject);
    }

    private void processRequest(RequestObject requestObject) {
        HttpEntity httpEntity = buildHttpEntity(requestObject);
        JSONObject responseJson;
        responseJson = restTemplate.postForEntity(requestUrl, httpEntity, JSONObject.class).getBody();
        log.info("民数api返回：{}", JSONObject.toJSONString(responseJson));

        if (null != responseJson) {
            boolean success;
            String code = Objects.toString(responseJson.get("code"));
            String msg = Objects.toString(responseJson.get("msg"));
            success = StringUtils.equals("0", code);
           if (!success) {
                throw new ApiSendException(msg);
            }
        }
    }


    private HttpEntity buildHttpEntity(RequestObject requestObject) {
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        JSONObject param = new JSONObject();
        param.put("certName", requestObject.getCertName());
        param.put("certNo", requestObject.getCertNo());
        param.put("contactNum", requestObject.getContactNum());
        param.put("postCityCode", requestObject.getPostCityCode());
        param.put("postProvinceCode", requestObject.getPostProvinceCode());
        param.put("postDistrictCode", requestObject.getPostDistrictCode());
        param.put("userId", userId);
        param.put("address", requestObject.getAddress());

        log.info("民数请求参数：{}", JSONObject.toJSONString(param));

        HttpEntity httpEntity = new HttpEntity(param.toString(), headers);
        return httpEntity;
    }


    @Data
    public static class RequestObject {
        private String certName;
        private String certNo;
        private String contactNum;
        private String postCityCode;
        private String postProvinceCode;
        private String postDistrictCode;
        private String address;
    }

}
