package com.bxm.shopping.integration.Liulv;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shopping.integration.ApiSendException;
import com.bxm.shopping.integration.Liulv.config.LiulvConfig;
import com.bxm.warcar.utils.UUIDHelper;
import com.google.common.base.Preconditions;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;

/**
 * 六律号卡 对接API
 *
 * @author tangx
 * @date 2021/4/19 14:28
 */
@Slf4j
@Configuration
public class LiulvIntegration {

    private final static String APP_ID = "llbxm";

    private final static String VERSION = "1.0.0";

    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private LiulvConfig liulvConfig;


    public void send(LiulvEntity liulvEntity) {
        checkRequest(liulvEntity);
        processRequest(liulvEntity);
    }

    private void processRequest(LiulvEntity liulvEntity) {
        HttpEntity httpEntity = buildHttpEntity(liulvEntity);
        JSONObject responseJson;
        try {
            String requestUrl = liulvConfig.getRequestUrl();
            responseJson = restTemplate.postForEntity(requestUrl, httpEntity, JSONObject.class).getBody();
        } catch (Exception e) {
            log.error("请求六律号卡接口异常：" + e.getMessage(), e);
            throw new ApiSendException("办理失败，请稍后再试");
        }
        log.info("六律号卡返回：{}", JSONObject.toJSONString(responseJson));

        if (null != responseJson) {
            boolean success;
            String code = (String) responseJson.get("code");
            String message = (String) responseJson.get("message");
            success = StringUtils.equals("200", code);
            if (!success && StringUtils.isNotBlank(message)) {
                throw new ApiSendException(message);
            }
            return;
        }
        throw new ApiSendException("办理失败，请稍后再试");
    }

    private void checkRequest(LiulvEntity liulvEntity) {
        Preconditions.checkArgument(StringUtils.isNotBlank(liulvEntity.getUserMobile()), "手机号不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(liulvEntity.getUserName()), "姓名不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(liulvEntity.getIdCard()), "身份证号不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(liulvEntity.getProvince()), "省份不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(liulvEntity.getCity()), "市不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(liulvEntity.getRegion()), "区县不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(liulvEntity.getAddress()), "地址不能为空");
    }


    private HttpEntity buildHttpEntity(LiulvEntity liulvEntity) {
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        JSONObject param = new JSONObject();
        JSONObject body = new JSONObject();
        JSONObject header = new JSONObject();
        header.put("appId", APP_ID);
        header.put("version", VERSION);
        header.put("requestId", UUIDHelper.generate());
        body.put("thirdOrderNo", liulvEntity.getOrderNum());
        body.put("addressPhone", liulvEntity.getUserMobile());
        body.put("userName", liulvEntity.getUserName());
        body.put("userCardNo", liulvEntity.getIdCard());
        body.put("province", liulvEntity.getProvince());
        body.put("city", liulvEntity.getCity());
        body.put("country", liulvEntity.getRegion());
        body.put("address", liulvEntity.getAddress());
        body.put("productId", liulvEntity.getProductExternalCode());
        param.put("header", header);
        param.put("body", body);

        log.info("六律号卡请求参数：{}", JSONObject.toJSONString(param));

        HttpEntity httpEntity = new HttpEntity(param.toString(), headers);
        return httpEntity;
    }


    public static void main(String[] args) {
        System.out.println();
    }

}
