package com.bxm.shopping.integration;

import com.alibaba.fastjson.JSONObject;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;

import java.util.Objects;

/**
 * @author tangx
 * @date 2022/4/1 14:05
 */
@Slf4j
@Configuration
public class Risk5243Checker {

    @Autowired
    @Qualifier("orderRestTemplate")
    private RestTemplate restTemplate = new RestTemplate();

    public static final String requestUrl = "https://api.hzylgs.com/java-api/h5api/unicomeRiskCheck";

    private static final String SUCCESS_CODE = "0000";

//    public static void main(String[] args) {
//        Risk5243Checker risk5243Checker = new Risk5243Checker();
//        risk5243Checker.send(new RequestObject(
//                "张一咪", "110101199701011000", "19888189635", "浙江", "杭州市", "滨江区", "西兴街道金茂府1单元"));
//    }

    public void send(Risk5243Checker.RequestObject requestObject) {
        processRequest(requestObject);
    }

    private void processRequest(Risk5243Checker.RequestObject requestObject) {
        HttpEntity httpEntity = buildHttpEntity(requestObject);
        JSONObject responseJson;
        responseJson = restTemplate.postForEntity(requestUrl, httpEntity, JSONObject.class).getBody();
        log.info("risk5243 api返回：{}", JSONObject.toJSONString(responseJson));

        if (null != responseJson) {
            boolean success;
            String data = responseJson.getString("data");
            String desc = responseJson.getString("desc");

            success = StringUtils.equals(SUCCESS_CODE, data);
            if (!success) {
                if (StringUtils.isBlank(desc)) {
                    desc = CodeEnum.getDescByCode(data);
                }
                throw new ApiSendException(desc);
            }
        }
    }


    private HttpEntity buildHttpEntity(Risk5243Checker.RequestObject requestObject) {
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        JSONObject param = new JSONObject();
        param.put("name", requestObject.getName());
        param.put("idCard", StringUtils.upperCase(requestObject.getIdCard()));
        param.put("mobile", requestObject.getMobile());
        param.put("province", requestObject.getProvince());
        param.put("city", requestObject.getCity());
        param.put("area", requestObject.getArea());
        param.put("address", requestObject.getAddress());

        log.info("risk5243 请求参数：{}", JSONObject.toJSONString(param));

        HttpEntity httpEntity = new HttpEntity(param.toString(), headers);
        return httpEntity;
    }


    @Data
    @AllArgsConstructor
    @Builder
    public static class RequestObject {
        private String name;
        private String idCard;
        private String mobile;
        private String province;
        private String city;
        private String area;
        private String address;
    }


    @Getter
    @AllArgsConstructor
    private enum CodeEnum {
        _0001("0001", "姓名、联系电话、收货地址超限"),
        _0005("0005", "证件号超限"),
        _0011("0011", "联系电话超限"),
        _0013("0013", "一证五户超限"),
        _0019("0019", "配送地址冲突"),
        _0021("0021", "未填写详细地址"),
        _0025("0025", "恶意地址"),
        _0026("0026", "待确认地址"),
        _0027("0027", "30天内同一证件、同一联电、同一收货地址下单超限"),
        _0038("0038", "证件90天内订单超过限制"),
        _0041("0041", "地址不匹配"),
        ;

        private String code;
        private String desc;


        public static String getDescByCode(String code) {
            if (StringUtils.isNotBlank(code)) {
                for (CodeEnum codeEnum : CodeEnum.values()) {
                    if (Objects.equals(code, codeEnum.getCode())) {
                        return codeEnum.getDesc();
                    }
                }
            }
            return "订单错误,校验未通过";
        }
    }


}
