package com.bxm.shopping.integration.acl;

import com.bxm.acl.facade.AclUserService;
import com.bxm.acl.facade.model.ResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

/**
 * @author yirenjie
 * createDate:  2018/10/19
 */
@Service
public class AclUserIntegration {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Resource
    private AclUserService aclUserService;

    public Map<String, String> queryUserByRoleCode(String roleCode) {
        try {
            ResultModel<Map<String, String>> response = aclUserService.queryUserByRoleCode(roleCode, false);
            if (response != null && response.isSuccessed() && response.getReturnValue() != null) {
                return response.getReturnValue();
            }
        } catch (Exception e){
            log.error("请求权限系统查询角色对应用户信息异常:", e);
        }
        return new HashMap<>();
    }
}
