package com.bxm.shopping.integration.adsmanager;

import com.bxm.adsmanager.facade.model.adTag.TblAdTagVo;
import com.bxm.adsmanager.facade.service.AdTagFacadeService;
import com.bxm.adsmanager.facade.service.RiskWordFacadeService;
import com.bxm.warcar.utils.response.ResultModel;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author tangx
 * @date 2021/9/13 17:32
 */
@Configuration
@Slf4j
public class AdsmanagerIntegration {
    @Autowired
    private RiskWordFacadeService riskWordFacadeService;
    @Autowired
    private AdTagFacadeService adTagFacadeService;


    public List<String> getRiskWord() {
        try {
            return riskWordFacadeService.getRiskWordList();
        } catch (Exception e) {
            log.error("调用adsmanager-web getRiskWordList 异常:" + e.getMessage(), e);
            return Collections.EMPTY_LIST;
        }
    }


    /**
     * 获取属性标签
     * @return
     */
    public List<TblAdTagVo> getAdTag() {
        ResultModel<PageInfo<TblAdTagVo>> newTreeAll = adTagFacadeService.findNewTreeAll(0, 2, null, 1, Integer.MAX_VALUE);
        if (Objects.nonNull(newTreeAll)) {
            PageInfo<TblAdTagVo> returnValue = newTreeAll.getReturnValue();
            if (Objects.nonNull(returnValue)) {
                return returnValue.getList();
            }
        }
        return Collections.EMPTY_LIST;
}


    public List<TblAdTagVo> getAdTagAll() {
        ResultModel<PageInfo<TblAdTagVo>> newAll = adTagFacadeService.findNewAll(1, Integer.MAX_VALUE, null, 2);
        if (Objects.nonNull(newAll)) {
            PageInfo<TblAdTagVo> returnValue = newAll.getReturnValue();
            if (Objects.nonNull(returnValue)) {
                return returnValue.getList();
            }
        }
        return Collections.EMPTY_LIST;
    }


    public Map<Integer, String> getAdTagNameMap() {
        List<TblAdTagVo> adTagAll = getAdTagAll();
        if (CollectionUtils.isNotEmpty(adTagAll)) {
            Map<Integer, String> map = adTagAll.stream().collect(Collectors.toMap(t -> t.getCode(), t -> t.getName()));
            return map;
        }

        return Collections.EMPTY_MAP;
    }
}
