package com.bxm.shopping.integration.adsmedia;

import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceUrlVO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author tangx
 * @date 2021/5/26 14:34
 */
@FeignClient(name = "adsmedia")
public interface AdsmediaFeignService {



    /**
     * Description: 根据 positionId 查询广告位
     * @param positionId 广告位ID
     * @return com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO
     */
    @RequestMapping(value = "/facade/appEntrance/findByPositionId", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResultModel<AppEntranceAdRO> findByPositionId(@RequestParam(name = "positionId") String positionId);

    /**
     * 获得广告位上的链接
     * @param positionId
     * @return
     */
    @RequestMapping(value = "/facade/appEntrance/getUrl", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResultModel<AppEntranceUrlVO> getUrl(@RequestParam(name = "positionId") String positionId);


    /**
     * Description: 查询广告位列表
     * JDK version used:<JDK1.8>
     */
    @RequestMapping(value = "/facade/appEntrance/getPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResultModel<PageInfo<AppEntranceAdRO>> getPage(@RequestBody QueryAppEntranceParamDTO dto);

}
