package com.bxm.shopping.integration.advertiser;

import com.bxm.shopping.integration.advertiser.model.Advertiser;
import com.bxm.shopping.integration.advertiser.model.AdvertiserShoppingDto;
import com.bxm.shopping.integration.advertiser.model.AdvertiserShoppingVo;
import com.bxm.warcar.utils.response.ResultModel;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient(name = "advertiser")
public interface AdvertiserFeignService {

    @RequestMapping(value = "/shopping/getList", method = RequestMethod.POST)
    public PageInfo<AdvertiserShoppingVo> getList(@RequestBody AdvertiserShoppingDto advertiserShoppingDto);


    @RequestMapping(value = "/shopping/updateShoppingStatus", method = RequestMethod.GET)
    public Boolean updateShoppingStatus(@RequestParam(value = "id") Integer id,
                                        @RequestParam(value = "isShopping") Integer isShopping);

    @RequestMapping(value = "/merchantLogin", method = RequestMethod.GET)
    public ResultModel<AdvertiserShoppingVo> merchantLogin(@RequestParam(value = "username", required = true) String username,
                                                           @RequestParam(value = "password", required = true) String password);

    @RequestMapping(value = "/shopping/updateMerchantEnable", method = RequestMethod.GET)
    public Boolean updateMerchantEnable(@RequestParam(value = "id") Integer id,
                                        @RequestParam(value = "isEnableMerchant") Byte isEnableMerchant);

    @RequestMapping(value = "/get/{id}", method = RequestMethod.GET)
    public ResultModel<Advertiser> getById(@PathVariable(value = "id") Integer id);
}
