package com.bxm.shopping.integration.advertiser;

import com.bxm.shopping.integration.advertiser.model.Advertiser;
import com.bxm.shopping.integration.advertiser.model.AdvertiserShoppingDto;
import com.bxm.shopping.integration.advertiser.model.AdvertiserShoppingVo;
import com.bxm.warcar.utils.response.ResultModel;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import java.util.List;

/**
 * @author tangx
 * @date 2020/8/19 13:48
 */
@Configuration
public class AdvertiserIntegration {

    @Autowired
    private AdvertiserFeignService advertiserFeignService;

    public AdvertiserShoppingVo merchantLogin(String userName, String password) {
        ResultModel<AdvertiserShoppingVo> resultModel = advertiserFeignService.merchantLogin(userName, password);
        if (resultModel == null || !resultModel.isSuccessed()) {
            return null;
        }
        AdvertiserShoppingVo vo = resultModel.getReturnValue();
        return vo;
    }

    public Advertiser getAdvertiserById(Integer advertiserId) {
        ResultModel<Advertiser> resultModel = advertiserFeignService.getById(advertiserId);
        if (resultModel == null || !resultModel.isSuccessed()) {
            return null;
        }
        Advertiser advertiser = resultModel.getReturnValue();
        return advertiser;
    }

    public List<AdvertiserShoppingVo> getAdvertiserList(AdvertiserShoppingDto dto) {
        PageInfo<AdvertiserShoppingVo> pageInfo = advertiserFeignService.getList(dto);
        if (pageInfo == null) {
            return null;
        }
        return pageInfo.getList();
    }
}
