package com.bxm.shopping.integration.jizhengyun;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.shopping.integration.jizhengyun.model.ClientRequest;
import com.bxm.shopping.integration.jizhengyun.model.Constants;
import com.bxm.shopping.integration.jizhengyun.model.CustomerKeys;
import com.bxm.shopping.integration.jizhengyun.model.SerialNumberUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;

/**
 * @author tangx
 * @date 2021/8/24 14:48
 */
@Slf4j
@Component
public class IdCardVerifyIntegration {

    private final static Integer RESULT_SUCCESS = 1;
    private final static String CODE_SUCCESS = "0000";
    // 需要返回不一致的code
    private final static List<String> EXCLUDE_CODE = Collections.singletonList("1008");
    private static String baseUrl = "http://api.jizhengyun.com/v1.0/realname/";

    @Autowired
    private RestTemplate restTemplate;

//    public static void main(String[] args) throws Exception {
//        IdCardVerifyIntegration integration = new IdCardVerifyIntegration();
//        String name = "唐骁";
//        String cert_no = "430621199610030414";
//        integration.verify(name, cert_no);
//    }

    public boolean verify(String name, String idCard) {
        try {
            String resp = invoke(name, idCard.toUpperCase());
            Boolean result = analyzeResponse(resp);
            log.info("姓名{},身份证号：{}, verify result: {}", name, idCard, result);
            return result;
        } catch (Exception e) {
            log.info(e.getMessage(), e);
            return true;
        }
    }

    private Boolean analyzeResponse(String resp) {
        JSONObject RespJSON = JSONObject.parseObject(resp, JSONObject.class);
        log.info(RespJSON.toJSONString());
        String MessageStr = RespJSON.getString("message");
        JSONObject messageJSON = JSONObject.parseObject(MessageStr, JSONObject.class);

        String CODE = RespJSON.getString("code");
        if (! CODE.equals(CODE_SUCCESS) && EXCLUDE_CODE.contains(CODE)) {
            return false;
        }

        if (null != messageJSON) {
            String dataStr = messageJSON.getString("data");
            JSONObject dataJSON = JSONObject.parseObject(dataStr, JSONObject.class);

            if (dataJSON != null) {
                Integer result = (Integer) dataJSON.get("result");
                if (RESULT_SUCCESS.equals(result)) {
                    return true;
                }
            }
        }
        return false;
    }



    public String invoke(String name, String cert_no) throws UnsupportedEncodingException {
        // 订单号
        String out_trade_no = SerialNumberUtil.createBillNo();
        String tran_time = "2021-08-23 16:21:30";
        String verify_type = "0220";
        //测试商户号
        String cutomer_code = CustomerKeys.customer_code;
        String url = baseUrl + cutomer_code;
        // 3des密钥
        String des_key = CustomerKeys.des_key;
        //RSA私钥
        String rsa_key = CustomerKeys.rsa_key;
        ClientRequest molinkRequest = new ClientRequest();
        molinkRequest.setOut_trade_no(out_trade_no);
        molinkRequest.setTran_time(tran_time);
        molinkRequest.setVerify_type(verify_type);
        molinkRequest.setCustomer_code(cutomer_code);
        molinkRequest.setName(new String(name.getBytes(), "UTF-8"));
        molinkRequest.setCert_no(cert_no);

        StringBuilder builder = new StringBuilder();
        builder.append(Constants.out_trade_no.toUpperCase() + "=" + out_trade_no);
        builder.append("&" + Constants.tran_time.toUpperCase() + "=" + tran_time);
        builder.append("&" + Constants.verify_type.toUpperCase() + "=" + verify_type);
        builder.append("&" + Constants.name.toUpperCase() + "=" + name);
        builder.append("&" + Constants.cert_no.toUpperCase() + "=" + cert_no);

        String sign = RsaSignature.rsaSign(builder.toString(), rsa_key, Constants.CHARSET_UTF8);
        molinkRequest.setSign(sign);

        String json = JSON.toJSONString(molinkRequest);
        byte[] keybyte = des_key.getBytes();
        byte[] requsest = ThreeDesUtil.encryptMode(keybyte, json.getBytes());
        String code = restTemplate.postForObject(url, ThreeDesUtil.byte2Hex(requsest), String.class);
        log.info("身份验证接口返回数据: {}", code);
        return code;
    }

}