/**
 * Alipay.com Inc.
 * Copyright (c) 2004-2012 All Rights Reserved.
 */
package com.bxm.shopping.integration.jizhengyun;

import com.bxm.shopping.integration.jizhengyun.model.Constants;
import com.google.common.base.Strings;
import org.apache.commons.codec.binary.Base64;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;


public class RsaSignature
{
    
    /** RSA最大加密明文大小 */
    private static final int MAX_ENCRYPT_BLOCK = 117;
    
    /** RSA最大解密密文大小 */
    private static final int MAX_DECRYPT_BLOCK = 128;
    
    /**
     * 
     * @return
     */
    
    public static String rsaSign(String content, String privateKey, String charset)
        throws RuntimeException
    {
        try
        {
            PrivateKey priKey = getPrivateKeyFromPKCS8(Constants.SIGN_TYPE_RSA, new ByteArrayInputStream(privateKey.getBytes()));
            
            Signature signature = Signature.getInstance(Constants.SIGN_ALGORITHMS);
            
            signature.initSign(priKey);
            
            if (Strings.isNullOrEmpty(charset))
            {
                signature.update(content.getBytes());
            }
            else
            {
                signature.update(content.getBytes(charset));
            }
            
            byte[] signed = signature.sign();
            
            return new String(Base64.encodeBase64(signed));
        }
        catch (Exception e)
        {
            throw new RuntimeException("RSAcontent = " + content + "; charset = " + charset, e);
        }
    }
    
    public static PrivateKey getPrivateKeyFromPKCS8(String algorithm, InputStream ins)
        throws Exception
    {
        if (ins == null || Strings.isNullOrEmpty(algorithm))
        {
            return null;
        }
        
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        
        byte[] encodedKey = StreamUtil.readText(ins).getBytes();
        
        encodedKey = Base64.decodeBase64(encodedKey);
        
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
    }


}
